require( "scripts/style.lua" );




TitleFont = {
  standardFont,
  24,
  BorderColor
};

NameFont = {
  standardFont,
  18,
  BorderColor
};

function MakeIcon (num, myX, myY)
	return Group(
		{
			Bitmap
			{
				name="icon"..num,
				x = myX, y = myY,
				w=125, h=125,
				image = "",
			};
			
			Text
			{
				font = NameFont,
				name = "name"..num,
				x=myX,y=myY+130,w=125,h=80,
				flags = kHAlignCenter + kVAlignTop,
				label = ""
			};
		}
	);
	
end

MakeDialog
{
	Bitmap
	{ 
		image="backgrounds/longdialog",	
		x=kCenter,
		y=kCenter,
		
		ClothingUnlocked
		{
			x = 0, y = 0,
			w = kMax, h = kMax,
			
			Text
			{
				font = TitleFont,
				name = "title",
				x=50,y=30,w=300,h=80,
				flags = kHAlignCenter + kVAlignTop,
				label = "clothingunlocked"
			};
			
			
			MakeIcon(0, 55, 90);
			MakeIcon(1, 225, 90);
			
			MakeIcon(2, 55, 260);
			MakeIcon(3, 225, 260);

		
			SetStyle(SmallButtonStyle);
			
			Button
			{
				x=kCenter,
				y=-75,
				name="ok",
				label="ok",
				command=
						function()
							PopModal();
						end
			},
			SetStyle(DefaultStyle);
				
		},
	},
}